
# Vault Customer

This object represents a merchant’s customer, allowing them to store contact details, and track all payments associated with the same customer.

## Structure

`VaultCustomer`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `id` | `?string` | Optional | The unique ID for a customer generated by PayPal.<br><br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `22`, *Pattern*: `^[0-9a-zA-Z_-]+$` | getId(): ?string | setId(?string id): void |
| `name` | [`?Name`](../../doc/models/name.md) | Optional | The name of the party. | getName(): ?Name | setName(?Name name): void |

## Example (as JSON)

```json
{
  "id": "id2",
  "name": {
    "given_name": "given_name2",
    "surname": "surname8"
  }
}
```

